﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class PatientInstrumentsMain : BaseTBIInstrumentPage
{

    #region Variable Declarations

    private string _inSiteCode;
    private string _inDUZ;
    private string _inDFN;

    private string _inServerIP;
    private string _inServerPort;

    private int _inTBIEvaluationNoteId;
    private int _inTBIFollowUpNoteId;

    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    public event MasterPageMenuClickHandler MenuClick;

    #endregion

    #region Protected Methods

    protected void Menu2_MenuItemClick(object sender, MenuEventArgs e)
    {
        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PanelPatientConfirm.Visible = true;
            PanelInstrumentList.Visible = false;

            //Get parameters from session variables 
            _inSiteCode = Helpers.GetStringFromSessionVariable(Session["SiteCode"]);
            _inDUZ = Helpers.GetStringFromSessionVariable(Session["DUZ"]);
            _inDFN = Helpers.GetStringFromSessionVariable(Session["DFN"]);
            _inServerIP = Helpers.GetStringFromSessionVariable(Session["ServerIP"]);
            _inServerPort = Helpers.GetStringFromSessionVariable(Session["ServerPort"]);

            int.TryParse(Helpers.GetStringFromSessionVariable(Session["TBIEvaluationNoteId"]), out _inTBIEvaluationNoteId);
            int.TryParse(Helpers.GetStringFromSessionVariable(Session["TBIFollowUpNoteId"]), out _inTBIFollowUpNoteId);

            if (string.IsNullOrEmpty(_inDUZ)
                || string.IsNullOrEmpty(_inDFN)
                || string.IsNullOrEmpty(_inSiteCode)
                || string.IsNullOrEmpty(_inServerIP)
                || string.IsNullOrEmpty(_inServerPort))
            {
                //if any value is not passed in then the page was called incorrectly, display error message to user
                Response.Redirect("Warning.aspx?err=7", false);
            }

            TBIServiceTO _tbiServiceTo = new TBIServiceTO();

            _tbiServiceTo.siteCode = _inSiteCode;
            _tbiServiceTo.DUZ = _inDUZ;
            _tbiServiceTo.DFN = _inDFN;
            _tbiServiceTo.CprsSentTBIEvaluationNoteId = _inTBIEvaluationNoteId;
            _tbiServiceTo.CprsSentTBIFollowUpNoteId = _inTBIFollowUpNoteId;

            _tbiServiceTo.ServerIP = _inServerIP;
            _tbiServiceTo.ServerPort = _inServerPort;

            AddtoSessionTBIServiceTo(_tbiServiceTo);

            base.BaseTBIInstrumentPage_Load(sender, e);

            if (_tbiInstrumentManager.TbiServiceTo != null)
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);

            PanelInstrumentList.Visible = true;
            try
            {
                if (_tbiInstrumentManager.TbiServiceTo != null)
                {
                    // _tbiInstrumentManager.GetActiveInstrumentList() - RTK - new database driven call to get instrument titles for list
                    GridViewInstruments.DataSource = _tbiInstrumentManager.GetActiveInstrumentList(); //_tbiInstrumentManager.TbiServiceTo.Instruments;
                    GridViewInstruments.DataBind();
                    Logging.WriteLogToFile("PatientInstrumentMain Loaded");
                }
            }
            catch (Exception _ex)
            {
                Exception _tbilogerror = HandleTBIException(_ex, "PatientInstrumentsMain.aspx", "100006", "GridViewInstruments-DataBind()");

            }
        }
        else
        {
            TBIServiceTO _tbiServiceTo;

            try
            {
                _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
                _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;
                Logging.WriteLogToFile("PatientInstrumentMain Loaded");
            }
            catch (Exception _ex2)
            {
                Exception _tbilogerror = HandleTBIException(_ex2, "PatientInstrumentsMain.aspx", "100006", "TBIServiceTO-Session");
            }
        }
    }

    protected int ConfirmPatient(string snum)
    {
        string error = String.Empty;

        int ret = 2; //Default to generic error

        string formattedSnum = snum.Replace("-", "");

        try
        {
            if (formattedSnum == _tbiInstrumentManager.TbiServiceTo.PatientSnum)
            {
                if (LabelPatient.Text != _tbiInstrumentManager.TbiServiceTo.PatientName)
                {
                    ret = 11;
                }
                else
                {
                    AddtoSessionSSN(formattedSnum);

                    PatientManager pManager = new PatientManager();
                    string patICN = pManager.GetPatientICNBySnum(formattedSnum);

                    if (!string.IsNullOrEmpty(patICN))
                    {

                        PanelPatientConfirm.Visible = false;
                        PanelInstrumentList.Visible = true;

                        GridViewInstruments.DataSource = _tbiInstrumentManager.TbiServiceTo.Instruments;
                        GridViewInstruments.DataBind();

                        return 0;
                    }
                    else
                    {
                        Survey_Patient surveyPatient = new Survey_Patient();
                        surveyPatient.SetAsChangeTrackingRoot(EntityState.New, true);
                        surveyPatient.PATIENT_ICN = _tbiInstrumentManager.TbiServiceTo.PatientICN;

                        if (String.IsNullOrEmpty(surveyPatient.PATIENT_ICN))
                        {
                            error = "Patient's record cannot be added to the Registries database because the ICN identifier is blank; contact your Registries Administrator for assistance.";
                            DisplayErrorMessage(error);
                            return 1;
                        }
                        else
                        {
                            try
                            {
                                surveyPatient.STD_INSTITUTION_ID = Convert.ToInt32(_tbiInstrumentManager.TbiServiceTo.PatientLocationId);
                            }
                            catch (Exception e)
                            {
                                //Invalid value. Ignore error and leave the STD_INSTITUTION_ID field blank
                            }
                            surveyPatient.Snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                            try
                            {
                                surveyPatient.BIRTH_DATE = Convert.ToDateTime(_tbiInstrumentManager.TbiServiceTo.PatientDOB.Insert(4, "-").Insert(7, "-"));
                            }
                            catch (Exception e)
                            {
                                //Invalid value. Ignore error and leave the BIRTH_DATE field blank
                            }
                            fillPatientNameFields(ref surveyPatient, _tbiInstrumentManager.TbiServiceTo.PatientName);
                            surveyPatient.GENDER = _tbiInstrumentManager.TbiServiceTo.PatientGender;
                            surveyPatient.STA6N = _tbiInstrumentManager.TbiServiceTo.STA6N;
                            surveyPatient.DFN = _tbiInstrumentManager.TbiServiceTo.PatientDFN;

                            if (!pManager.AddSurveyPatient(surveyPatient))
                            {
                                error = "Unable to add Patient record to the Registries database; contact your Registries Administrator for assistance.";
                                DisplayErrorMessage(error);

                                ret = 1;
                            }
                            else
                            {
                                ret = 0;
                            }
                        }
                    }
                }
            }
            else
            {
                //Make sure there is no application context corruption
                if (Session["ConfirmedSSN"] != null)
                {
                    if (Session["ConfirmedSSN"].ToString() != formattedSnum)
                    {
                        ret = 11;
                    }
                }
                else
                {
                    if (LabelPatient.Text != _tbiInstrumentManager.TbiServiceTo.PatientName)
                    {
                        ret = 11;
                    }
                    else
                    {
                        //provide message that ssn is not correct - verify correct patient is selected in CPRS
                        error = "The SSN entered does not match the patient that you had selected in CPRS.  Please re-confirm the SSN.";
                        DisplayErrorMessage(error);

                        ret = 1;
                    }
                }
            }
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "ConfirmPatient()");
        }

        return ret;
    }

    protected void GridViewInstruments_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        try
        {
            Page.Validate();

            if (Page.IsValid)
            {
                int errCode = ConfirmPatient(TextBoxSSNConfirm.Text.Trim());
                switch (errCode)
                {
                    case 0:
                        int selectedInstrumentId = Convert.ToInt32(e.CommandArgument);

                        _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType =
                            (from i in _tbiInstrumentManager.GetAllInstrumentList()
                             where i.Id == selectedInstrumentId
                             select i).FirstOrDefault();

                        AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                        //Retrieve status of comprehensive survey
                        string status = String.Empty;
                        SURVEY survey = null;
                        if (selectedInstrumentId == 2) //Comprehensive survey
                        {
                            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(_tbiInstrumentManager.TbiServiceTo.PatientICN, 2, false).ToList();

                            if (surveys.Count > 0)
                            {
                                survey = surveys.First();
                                if (survey.SURVEY_STATUS != null)
                                {
                                    status = survey.SURVEY_STATUS.ToLower();
                                }

                            }
                        }

                        if (status == "completed")
                        {
                            if (survey != null)
                            {
                                Session["survey"] = survey;
                                Session["ViewOnly"] = true;
                            }

                            Response.Redirect("InstrumentSummaryNote.aspx", false);
                        }
                        else
                        {
                            Response.Redirect("Instrument.aspx", false);
                        }

                        break;
                    case 1:
                        break; // Corresponds to popping an alert 
                    default:
                        //Display error message to user
                        Response.Redirect(string.Format("Warning.aspx?err={0}", errCode), false);
                        break;
                }
            }
            else
            {
                string errMsg = "";

                foreach (IValidator aValidator in this.Validators)
                {
                    if (!aValidator.IsValid)
                    {
                        errMsg = aValidator.ErrorMessage;
                    }
                }

                if (errMsg != "")
                    ShowAlert(errMsg);
            }
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "GridViewInstruments_RowCommand()");
        }
    }





    protected void Button_ViewLastThreeInstruments(object sender, EventArgs e)
    {
        try
        {
            Page.Validate();

            if (Page.IsValid)
            {
                int errCode = ConfirmPatient(TextBoxSSNConfirm.Text.Trim());
                switch (errCode)
                {
                    case 0:
                        int selectedInstrumentId = 2;

                        _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType =
                            (from i in _tbiInstrumentManager.GetAllInstrumentList()
                             where i.Id == selectedInstrumentId
                             select i).FirstOrDefault();

                        AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                        //Retrieve status of comprehensive survey
                        string status = String.Empty;
                        SURVEY survey = null;
                        if (selectedInstrumentId == 2) //Comprehensive survey
                        {
                            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(_tbiInstrumentManager.TbiServiceTo.PatientICN, 2, false).ToList();

                            if (surveys.Count > 0)
                            {
                                survey = surveys.First();
                                if (survey.SURVEY_STATUS != null)
                                {
                                    status = survey.SURVEY_STATUS.ToLower();
                                }

                            }
                        }

                        if (status == "completed")
                        {
                            if (survey != null)
                            {
                                Session["survey"] = survey;
                                Session["ViewOnly"] = true;
                            }

                            Response.Redirect("InstrumentLastThree.aspx", false);
                        }
                        else
                        {
                            Response.Redirect("InstrumentLastThree.aspx", false);
                        }

                        break;
                    case 1:
                        break; // Corresponds to popping an alert 
                    default:
                        //Display error message to user
                        Response.Redirect(string.Format("Warning.aspx?err={0}", errCode), false);
                        break;
                }
            }
            else
            {
                string errMsg = "";

                foreach (IValidator aValidator in this.Validators)
                {
                    if (!aValidator.IsValid)
                    {
                        errMsg = aValidator.ErrorMessage;
                    }
                }

                if (errMsg != "")
                    ShowAlert(errMsg);
            }
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "GridViewInstruments_RowCommand()");
        }
    }


    protected void Button_ViewLastAllInstruments(object sender, EventArgs e)
    {
        try
        {
            Page.Validate();

            if (Page.IsValid)
            {
                int errCode = ConfirmPatient(TextBoxSSNConfirm.Text.Trim());
                switch (errCode)
                {
                    case 0:
                        int selectedInstrumentId = 2;

                        _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType =
                            (from i in _tbiInstrumentManager.GetAllInstrumentList()
                             where i.Id == selectedInstrumentId
                             select i).FirstOrDefault();

                        AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                        //Retrieve status of comprehensive survey
                        string status = String.Empty;
                        SURVEY survey = null;
                        if (selectedInstrumentId == 2) //Comprehensive survey
                        {
                            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(_tbiInstrumentManager.TbiServiceTo.PatientICN, 2, false).ToList();

                            if (surveys.Count > 0)
                            {
                                survey = surveys.First();
                                if (survey.SURVEY_STATUS != null)
                                {
                                    status = survey.SURVEY_STATUS.ToLower();
                                }

                            }
                        }

                        if (status == "completed")
                        {
                            if (survey != null)
                            {
                                Session["survey"] = survey;
                                Session["ViewOnly"] = true;
                            }

                            Response.Redirect("InstrumentLastAll.aspx", false);
                        }
                        else
                        {
                            Response.Redirect("InstrumentLastAll.aspx", false);
                        }

                        break;
                    case 1:
                        break; // Corresponds to popping an alert 
                    default:
                        //Display error message to user
                        Response.Redirect(string.Format("Warning.aspx?err={0}", errCode), false);
                        break;
                }
            }
            else
            {
                string errMsg = "";

                foreach (IValidator aValidator in this.Validators)
                {
                    if (!aValidator.IsValid)
                    {
                        errMsg = aValidator.ErrorMessage;
                    }
                }

                if (errMsg != "")
                    ShowAlert(errMsg);
            }
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "GridViewInstruments_RowCommand()");
        }
    }

    protected void ShowAlert(string message)
    {
        try
        {
            string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
            ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "ShowALert()");
        }
    }

    #endregion

    #region Private Methods

    private void DisplayErrorMessage(string sErrorMessage)
    {
        try
        {
            if (!LabelWarningNotificationMessage.Visible)
            {
                LabelWarningNotificationMessage.Visible = true;
                LabelWarningNotificationMessage.Text = sErrorMessage;

                StringBuilder oErrorScript = new StringBuilder();
                string sScript1 = @"<script type=""text/javascript"" language=""JavaScript"">";
                string sScript2a = @" alert('";
                string sScript2b = @"')";
                string sScript3 = @"</script>";
                oErrorScript.AppendLine(sScript1);
                oErrorScript.Append(sScript2a);


                oErrorScript.Append(sErrorMessage.Replace("'", "\\'"));

                oErrorScript.AppendLine(sScript2b);
                oErrorScript.AppendLine(sScript3);

                ClientScript.RegisterStartupScript(this.GetType(), "AlertMessage", oErrorScript.ToString());

                return;
            }
            else
            {
                LabelWarningNotificationMessage.Visible = false;
            }
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "DisplayErrorMessage()");
        }
    }

    private void fillPatientNameFields(ref Survey_Patient surveyPatient, string fullName)
    {
        string name;
        string firstName = "";
        string middleName = "";
        string lastName = "";
        int commaPosition;
        int spacePosition;

        try
        {
            name = fullName.Trim();
            commaPosition = name.IndexOf(",");
            if (commaPosition < 0)
                commaPosition = name.Length;

            lastName = name.Substring(0, commaPosition);

            try
            {
                name = fullName.Substring(commaPosition + 1).Trim();

                spacePosition = name.IndexOf(" ");
                if (spacePosition < 0)
                    spacePosition = name.Length;

                firstName = name.Substring(0, spacePosition).Trim();
                middleName = name.Substring(spacePosition + 1).Trim();
            }
            catch
            {
                //Ignore error
            }

            surveyPatient.FIRST_NAME = firstName;
            surveyPatient.MIDDLE_NAME = middleName;
            surveyPatient.LAST_NAME = lastName;
        }
        catch (Exception ex)
        {
            //Keep default error code
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsMain.aspx", "100006", "fillPatientNameFields()");
        }
    }

    #endregion
}